<?php
require __DIR__ . '/../lib/helpers.php';
require __DIR__ . '/../lib/auth.php';
require __DIR__ . '/../config/db.php';
require_user();
check_csrf();
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $pass = $_POST['password'] ?? '';
  if (strlen($pass)>=8) {
    $pdo->prepare("UPDATE users SET password=? WHERE id=?")->execute([password_hash($pass,PASSWORD_BCRYPT), $_SESSION['user']['id']]);
    $msg="Password changed.";
  } else $err="Password too short.";
}
include __DIR__ . '/partials/header.php'; include __DIR__ . '/partials/navbar.php';
?>
<div class="container py-5" style="max-width:520px;">
  <h2 class="h4 mb-3">Change Password</h2>
  <?php if(!empty($msg)) echo '<div class="alert alert-success">'.$msg.'</div>'; ?>
  <?php if(!empty($err)) echo '<div class="alert alert-danger">'.$err.'</div>'; ?>
  <form method="post">
    <?php echo csrf_field(); ?>
    <div class="mb-3"><label class="form-label">New Password</label><input type="password" name="password" class="form-control" minlength="8" required></div>
    <button class="btn btn-primary">Update</button>
  </form>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
