<?php
$loggedIn = !empty($_SESSION['user']);
?>
<nav class="navbar navbar-expand-lg bg-white border-bottom sticky-top">
  <div class="container">
    <a class="navbar-brand fw-bold" href="/public/index.php"><?php echo SITE_NAME; ?></a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nav">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div id="nav" class="collapse navbar-collapse">
      <ul class="navbar-nav me-auto">
        <li class="nav-item"><a class="nav-link" href="/public/index.php">Home</a></li>
        <li class="nav-item"><a class="nav-link" href="/public/enquiry.php">Enquiry</a></li>
        <li class="nav-item"><a class="nav-link" href="/public/my_bookings.php">My Bookings</a></li>
      </ul>
      <ul class="navbar-nav ms-auto">
        <?php if($loggedIn): ?>
          <li class="nav-item"><span class="nav-link">Hi, <?php echo e($_SESSION['user']['name']); ?></span></li>
          <li class="nav-item"><a class="btn btn-outline-danger btn-sm" href="/public/logout.php">Logout</a></li>
        <?php else: ?>
          <li class="nav-item"><a class="nav-link" href="/public/login.php">Login</a></li>
          <li class="nav-item"><a class="btn btn-primary btn-sm" href="/public/register.php">Register</a></li>
        <?php endif; ?>
        <li class="nav-item ms-2"><a class="btn btn-secondary btn-sm" href="/admin/login.php">Admin</a></li>
      </ul>
    </div>
  </div>
</nav>
