<?php
require __DIR__ . '/../config/constants.php';
require __DIR__ . '/../lib/helpers.php';
require __DIR__ . '/../config/db.php';
if (session_status() === PHP_SESSION_NONE) session_start();

// Fetch categories & packages
$cats = $pdo->query("SELECT * FROM categories ORDER BY name")->fetchAll();
$packages = $pdo->query("SELECT p.*, c.name as category FROM packages p LEFT JOIN categories c ON c.id=p.category_id ORDER BY p.id DESC LIMIT 8")->fetchAll();

include __DIR__ . '/partials/header.php';
include __DIR__ . '/partials/navbar.php';
?>
<section class="hero text-center">
  <div class="container">
    <h1 class="display-5 fw-bold">Discover Your Next Adventure</h1>
    <p class="lead">Curated tour packages across beaches, mountains, cities, and wildlife.</p>
    <a href="#packages" class="btn btn-primary btn-lg">Browse Packages</a>
  </div>
</section>

<div class="container my-5">
  <h2 class="h4 mb-3">Categories</h2>
  <div class="row g-3">
    <?php foreach($cats as $cat): ?>
    <div class="col-6 col-md-3">
      <a class="text-decoration-none" href="/public/index.php?category=<?php echo e($cat['id']); ?>">
        <div class="card shadow-sm">
          <div class="card-body text-center">
            <div class="fw-bold"><?php echo e($cat['name']); ?></div>
          </div>
        </div>
      </a>
    </div>
    <?php endforeach; ?>
  </div>

  <h2 id="packages" class="h4 mt-5 mb-3">Featured Packages</h2>
  <div class="row g-3">
    <?php foreach($packages as $p): ?>
    <div class="col-md-3">
      <div class="card shadow-sm h-100">
        <img src="/public/assets/images/<?php echo e($p['image'] ?? 'placeholder.jpg'); ?>" class="card-img-top" alt="image">
        <div class="card-body d-flex flex-column">
          <div class="small text-muted mb-1"><?php echo e($p['category']); ?></div>
          <h5 class="card-title"><?php echo e($p['title']); ?></h5>
          <p class="card-text flex-grow-1"><?php echo e(substr($p['description'],0,90)); ?>...</p>
          <div class="d-flex justify-content-between align-items-center">
            <span class="fw-bold">₹<?php echo number_format($p['price'],2); ?></span>
            <a href="/public/booking.php?package_id=<?php echo e($p['id']); ?>" class="btn btn-sm btn-primary">Book</a>
          </div>
        </div>
      </div>
    </div>
    <?php endforeach; ?>
  </div>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
