<?php
require __DIR__ . '/../lib/helpers.php';
require __DIR__ . '/../lib/auth.php';
require __DIR__ . '/../config/db.php';
require_user();
check_csrf();
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $sub = trim($_POST['subject'] ?? '');
  $msg = trim($_POST['message'] ?? '');
  if ($sub && $msg) {
    $pdo->prepare("INSERT INTO issues(user_id,subject,message) VALUES(?,?,?)")->execute([$_SESSION['user']['id'],$sub,$msg]);
    $id = $pdo->lastInsertId();
    $ticket = sprintf("TKT-%06d", $id);
    flash('success', "Ticket generated: $ticket");
    header("Location: /public/my_bookings.php"); exit;
  } else $err="All fields required.";
}
include __DIR__ . '/partials/header.php'; include __DIR__ . '/partials/navbar.php';
?>
<div class="container py-5" style="max-width:680px;">
  <h2 class="h4 mb-3">Generate Ticket (Complaint)</h2>
  <?php if(!empty($err)) echo '<div class="alert alert-danger">'.$err.'</div>'; ?>
  <form method="post">
    <?php echo csrf_field(); ?>
    <div class="mb-3"><label class="form-label">Subject</label><input class="form-control" name="subject" required></div>
    <div class="mb-3"><label class="form-label">Message</label><textarea class="form-control" rows="5" name="message" required></textarea></div>
    <button class="btn btn-primary">Submit</button>
  </form>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
