<?php
require __DIR__ . '/../lib/auth.php'; require_admin();
require __DIR__ . '/../config/db.php'; require __DIR__ . '/../lib/helpers.php';
if (($_GET['action'] ?? '')==='status' && $_SERVER['REQUEST_METHOD']==='POST') {
  $pdo->prepare("UPDATE bookings SET status=? WHERE id=?")->execute([$_POST['status'], $_POST['id']]);
  flash('ok','Status updated.');
  redirect('/admin/bookings.php');
}
$ok = flash('ok');
include __DIR__ . '/partials/header.php';
$rows = $pdo->query("SELECT b.*, u.name as user, p.title as package FROM bookings b JOIN users u ON u.id=b.user_id JOIN packages p ON p.id=b.package_id ORDER BY b.id DESC")->fetchAll();
?>
<h3 class="mb-3">Manage Bookings</h3>
<?php if($ok) echo '<div class="alert alert-success">'.$ok.'</div>'; ?>
<div class="table-responsive">
<table class="table table-striped align-middle">
  <thead><tr><th>ID</th><th>User</th><th>Package</th><th>Start</th><th>Travelers</th><th>Status</th><th>Action</th></tr></thead>
  <tbody><?php foreach($rows as $r): ?><tr>
    <td><?php echo $r['id']; ?></td><td><?php echo e($r['user']); ?></td><td><?php echo e($r['package']); ?></td><td><?php echo e($r['start_date']); ?></td><td><?php echo e($r['travelers']); ?></td>
    <td><span class="badge bg-secondary"><?php echo e($r['status']); ?></span></td>
    <td>
      <form class="d-flex" method="post" action="/admin/bookings.php?action=status">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="id" value="<?php echo $r['id']; ?>">
        <select class="form-select form-select-sm me-2" name="status">
          <?php foreach(['pending','confirmed','cancelled'] as $s): ?>
            <option value="<?php echo $s; ?>" <?php if($s==$r['status']) echo 'selected'; ?>><?php echo $s; ?></option>
          <?php endforeach; ?>
        </select>
        <button class="btn btn-sm btn-dark">Update</button>
      </form>
    </td>
  </tr><?php endforeach; ?></tbody>
</table>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
