<?php
require __DIR__ . '/config/constants.php';
require __DIR__ . '/config/db.php';

echo "Running database migrations and seeding...\n";

$sql = file_get_contents(__DIR__ . '/sql/schema.sql');
$pdo->exec($sql);

// Create admin user if not exists
$adminEmail = ADMIN_EMAIL;
$adminPass  = ADMIN_PASSWORD;
$exists = $pdo->prepare("SELECT id FROM users WHERE email = ?");
$exists->execute([$adminEmail]);
if (!$exists->fetch()) {
  $stmt = $pdo->prepare("INSERT INTO users(name, email, password, role) VALUES(?,?,?, 'admin')");
  $stmt->execute(['Administrator', $adminEmail, password_hash($adminPass, PASSWORD_BCRYPT)]);
  echo "Admin created with email: $adminEmail\n";
} else {
  echo "Admin already exists: $adminEmail\n";
}

// Seed categories
$cats = ['Beach Escapes','Mountain Trails','City Tours','Wildlife Safaris'];
foreach ($cats as $c) {
  $slug = strtolower(preg_replace('/[^a-z0-9]+/','-', $c));
  $pdo->prepare("INSERT IGNORE INTO categories(name, slug) VALUES(?,?)")->execute([$c, $slug]);
}

// Seed packages
$samplePackages = [
  ['Beach Bliss - Goa', 'Enjoy sun, sand, and seafood in Goa.', 14999.00, 4, 'beach.jpg', 'Beach Escapes'],
  ['Himalayan Trek', 'Guided trek with breathtaking views.', 21999.00, 6, 'mountain.jpg', 'Mountain Trails'],
  ['Delhi & Agra Highlights', 'Explore the Taj Mahal and historic Delhi.', 12999.00, 3, 'city.jpg', 'City Tours'],
  ['Ranthambore Safari', 'Spot tigers and wildlife in Ranthambore.', 17999.00, 3, 'wildlife.jpg', 'Wildlife Safaris'],
];
foreach ($samplePackages as $p) {
  [$title, $desc, $price, $days, $img, $catName] = $p;
  $cidStmt = $pdo->prepare("SELECT id FROM categories WHERE name=?");
  $cidStmt->execute([$catName]);
  $cid = $cidStmt->fetchColumn();
  $stmt = $pdo->prepare("INSERT INTO packages(category_id,title,description,price,duration_days,image) VALUES (?,?,?,?,?,?)");
  $stmt->execute([$cid, $title, $desc, $price, $days, $img]);
}

// Seed pages
$pages = [
  ['about', 'About Us', '<p>We craft unforgettable travel experiences.</p>'],
  ['terms', 'Terms & Conditions', '<p>Standard terms apply.</p>'],
  ['privacy', 'Privacy Policy', '<p>Your privacy matters to us.</p>'],
];
foreach ($pages as $pg) {
  [$slug,$title,$content] = $pg;
  $pdo->prepare("INSERT IGNORE INTO pages(slug,title,content) VALUES(?,?,?)")->execute([$slug,$title,$content]);
}

echo "Seeding complete.\n";
?>
