<?php
// Shared PDO connection
$config = require __DIR__ . '/config.php';
$dsn = sprintf('mysql:host=%s;port=%s;dbname=%s;charset=%s',
  $config['host'], $config['port'], $config['database'], $config['charset']
);
try {
  $pdo = new PDO($dsn, $config['username'], $config['password'], [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
  ]);
} catch (PDOException $e) {
  die('DB Connection failed: ' . htmlspecialchars($e->getMessage()));
}
?>
