<?php
require __DIR__ . '/../lib/helpers.php';
require __DIR__ . '/../config/db.php';
if (session_status() === PHP_SESSION_NONE) session_start();
check_csrf();
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $email = trim($_POST['email'] ?? '');
  $pass = $_POST['password'] ?? '';
  $stmt = $pdo->prepare("SELECT * FROM users WHERE email=? AND role='admin'");
  $stmt->execute([$email]);
  $u = $stmt->fetch();
  if ($u && password_verify($pass, $u['password'])) {
    $_SESSION['admin'] = ['id'=>$u['id'], 'name'=>$u['name'], 'email'=>$u['email']];
    header("Location: /admin/index.php"); exit;
  } else { $err="Invalid credentials."; }
}
include __DIR__ . '/partials/header.php';
?>
<div class="container py-5" style="max-width:480px;">
  <h2 class="h4 mb-3">Admin Login</h2>
  <?php if(!empty($err)) echo '<div class="alert alert-danger">'.$err.'</div>'; ?>
  <form method="post">
    <?php echo csrf_field(); ?>
    <div class="mb-3"><label class="form-label">Email</label><input type="email" name="email" class="form-control" required></div>
    <div class="mb-3"><label class="form-label">Password</label><input type="password" name="password" class="form-control" required></div>
    <button class="btn btn-dark w-100">Login</button>
  </form>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
